<?php
/**
* Require Thread Prefixes
* Version: 1.1
* Copyright 2011 fizz (http://community.mybb.com/user-36020.html), all rights reserved
* http://community.mybb.com/user-36020.html
* I don't take responsibility for any errors caused by this plugin. Always keep MyBB up to date and always keep this plugin up to date.
* This plugin was created and offered for subscribers of http://www.mybbforums.com originally, but I have now made it available FOR FREE from the Official MyBB Mods site.
* You may NOT redistribute this plugin, sell it, remove copyrights, or claim it as your own in any way.
**/

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

function require_prefixes_info()
{
	return array(
		'name'			=> 'هاك بادئة الموضوع',
		'description'	=> 'يسمح لك باجبار العضو علي وضع بادئة للموضوع في اقسام معينه',
		'website'		=> 'http://mods.mybb.com',
		'author'		=> 'fizz',
		'authorsite'	=> 'http://community.mybb.com/user-36020.html',
		'guid'			=> '7c4ab03740ed2d9e9a47b2bc3b36a63e',
		'version'		=> '1.1',
		'compatibility' => '16*'
	);
}

function require_prefixes_is_installed()
{
	global $db;
	if ($db->num_rows($db->simple_select("settings","name","name='rpx_forums'")) >= 1)	
	{
		return true;
	}
	return false;
}

$plugins->add_hook("datahandler_post_validate_thread", "rpx_do");

function require_prefixes_install(){} // does nothing, everything is run in activate()

function require_prefixes_activate()
{
	global $db;
	
	$rpx_group = array(
        "gid" => "NULL",
        "name" => "require_prefixes",
        "title" => "هاك بادئة المواضيع",
        "description" => "اعدادات الهاك",
        "disporder" => "1",
        "isdefault" => "no",
        );
	$db->insert_query("settinggroups", $rpx_group);
    $gid = $db->insert_id();
	
	$rpx_0 = array(
        "sid" => "NULL",
        "name" => "rpx_enabled",
        "title" => "تفعيل / ايقاف",
        "description" => "تستطيع ايقاف او تشغيل الهاك من هنا",
        "optionscode" => "yesno",
        "value" => "1",
        "disporder" => "1",
        "gid" => intval($gid),
        );
    $db->insert_query("settings", $rpx_0);
	
	/*$rpx_1 = array(  // saved temporarily if I decide to add in restricted usergroups later
        "sid" => "NULL",
        "name" => "rpx_groups",
        "title" => "Restricted Groups",
        "description" => "The id of the groups whose posts numbers are restricted. (Separate with a comma \'\,\')",
        "optionscode" => "text",
        "value" => "3,4,8",
        "disporder" => "1",
        "gid" => intval($gid),
        );
    $db->insert_query("settings", $rpx_1);*/
	
	$rpx_2 = array(
        "sid" => "NULL",
        "name" => "rpx_forums",
        "title" => "الاقسام",
        "description" => "ضع هنا ارقام الاقسام المراد تفعيل الهاك بها",
        "optionscode" => "text",
        "value" => "2,7,10",
        "disporder" => "2",
        "gid" => intval($gid),
        );
    $db->insert_query("settings", $rpx_2);
	
	$rpx_3 = array(
        "sid" => "NULL",
        "name" => "rpx_errmsg",
        "title" => "رسالة الخطأ",
        "description" => "اكتب هنا الرسالة التي سوف تظهر في حالة عدم وضع بادئة.",
        "optionscode" => "text",
        "value" => "هذا القسم بتطلب اضافة بادئة للمواضيع يرجي اختيار البادئة",
        "disporder" => "3",
        "gid" => intval($gid),
        );
    $db->insert_query("settings", $rpx_3);
	
	rebuild_settings();
}

function require_prefixes_deactivate()
{
	global $db, $mybb;
	$query = $db->query("SELECT gid FROM ".TABLE_PREFIX."settinggroups WHERE name='require_prefixes'");
    $g = $db->fetch_array($query);
    $db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE gid='".$g['gid']."'");
    $db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE gid='".$g['gid']."'");
	
	rebuild_settings();
}
function require_prefixes_uninstall(){} //does nothing, everything is run in deactivate() -> but it makes uninstall link show up in plugins menu

function rpx_do($post)
{
	global $mybb, $lang;
	//$group = $mybb->user['usergroup']; //if I include usergroup restriction later
	//$groups = explode(",",$mybb->settings['rpx_groups']); //if I include usergroup restriction later
	$lang->load("require_prefixes");
	
	if($mybb->settings['rpx_enabled'] == 1) //if plugin is turned on
	{
		if($mybb->settings['rpx_forums'] != "") //if there are actually forums set
		{
			$forums = explode(",", $mybb->settings['rpx_forums']);
			if(in_array($post->data['fid'], $forums))
			{
				if(intval($post->data['prefix']) == 0) //if prefix == 0 then no prefix is used
				{
					//$credits = "<br /><br /><b>MyBB Require Prefixes</b> plugin developed by <a href=\"http://www.mybbforums.com\" target=\"_blank\">MyBBForums.com</a>.";
					if($mybb->settings['rpx_errmsg'] != "") //use custom error msg if it exists
					{
						//$post->set_error("{$mybb->settings['rpx_errmsg']}{$credits}");
						$post->set_error("{$mybb->settings['rpx_errmsg']}");
					}
					else //custom err msg not set -> use default
					{
						//$post->set_error("Thread prefixes are required in this forum. You must select a prefix for your thread.{$credits}");
						$post->set_error($lang->noprefix);
					}
				}
			}
		}
	}
}

?>